#include <allegro.h>
#ifndef NO_GL
#include <alleggl.h>
#endif

#include "main.h"
#include "draw.h"

void color_(int lnum, int *lines)
{
#ifdef NO_GL
	int li;
	
	for (li = 0; li < lnum; li ++) {
		int r = lines[li * 5 + 2];
		int g = lines[li * 5 + 3];
		int b = lines[li * 5 + 4];
		lines[li * 5 + 2] = (r * 7 / 255) * 32 + (g * 7 / 255) * 4 + (b * 3 / 255);
	}
#endif
}

void bound_(int pnum, float *points, float *l, float *t, float *r, float *b)
{
	int pi;
	*l = 0;
	*r = 0;
	*t = 0;
	*b = 0;
	for (pi = 0; pi < pnum; pi++) {
		if (points[pi * 2] < *l) *l = points[pi * 2];
		if (points[pi * 2] > *r) *r = points[pi * 2];
		if (points[pi * 2 + 1] < *b) *b = points[pi * 2 + 1];
		if (points[pi * 2 + 1] > *t) *t = points[pi * 2 + 1];
	}
}
	
void draw_(int x, int y, int pnum, int lnum, float *points1, float *points2, int *lines, float ipol)
{
	int li;
	for (li = 0; li < lnum; li ++) {
		int pi1 = lines[li * 5];
		int pi2 = lines[li * 5 + 1];
#ifndef NO_GL
		int r = lines[li * 5 + 2];
		int g = lines[li * 5 + 3];
		int b = lines[li * 5 + 4];
		glBegin(GL_LINES);
		glColor3ub(r, g, b);
		glVertex3f(
			x + points1[pi1 * 2] * (1 - ipol) + points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			0
		);
		glVertex3f(
			x + points1[pi2 * 2] * (1 - ipol) + points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			0
		);
		glEnd();	
#else
		int c = lines[li * 5 + 2];
		line(page,
			x + points1[pi1 * 2] * (1 - ipol) + points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			x + points1[pi2 * 2] * (1 - ipol) + points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			c);
#endif
	}
}

void c_draw_(int x, int y, int pnum, int lnum, float *points1, float *points2, int *lines, float ipol, int c)
{
	int li;
	for (li = 0; li < lnum; li ++) {
		int pi1 = lines[li * 5];
		int pi2 = lines[li * 5 + 1];
#ifndef NO_GL
		int r = c >> 5;
		int g = (c >> 2) & 7;
		int b = c & 3;
		r = r * 255 / 7;
		g = g * 255 / 7;
		b = b * 255 / 3;
		glBegin(GL_LINES);
		glColor3ub(r, g, b);
		glVertex3f(
			x + points1[pi1 * 2] * (1 - ipol) + points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			0
		);
		glVertex3f(
			x + points1[pi2 * 2] * (1 - ipol) + points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			0
		);
		glEnd();	
#else
		line(page,
			x + points1[pi1 * 2] * (1 - ipol) + points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			x + points1[pi2 * 2] * (1 - ipol) + points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			c);
#endif
	}
}

void m_draw_(int x, int y, int pnum, int lnum, float *points1, float *points2, int *lines, float ipol)
{
	int li;
	for (li = 0; li < lnum; li ++) {
		int pi1 = lines[li * 5];
		int pi2 = lines[li * 5 + 1];
#ifndef NO_GL
		int r = lines[li * 5 + 2];
		int g = lines[li * 5 + 3];
		int b = lines[li * 5 + 4];
		glBegin(GL_LINES);
		glColor3ub(r, g, b);
		glVertex3f(
			x - points1[pi1 * 2] * (1 - ipol) - points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			0
		);
		glVertex3f(
			x - points1[pi2 * 2] * (1 - ipol) - points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			0
		);
		glEnd();	
#else
		int c = lines[li * 5 + 2];
		line(page,
			x - points1[pi1 * 2] * (1 - ipol) - points2[pi1 * 2] * ipol,
			y - points1[pi1 * 2 + 1] * (1 - ipol) - points2[pi1 * 2 + 1] * ipol,
			x - points1[pi2 * 2] * (1 - ipol) - points2[pi2 * 2] * ipol,
			y - points1[pi2 * 2 + 1] * (1 - ipol) - points2[pi2 * 2 + 1] * ipol,
			c);
#endif
	}
}
